from tkinter import Tk, Button, filedialog
from PIL import Image

def open_image():
    # Open file dialog to select an image
    file_path = filedialog.askopenfilename(filetypes=[("Image Files", "*.png;*.jpg;*.jpeg")])
    
    # Check if a file was selected
    if file_path:
        # Open the image using PIL
        image = Image.open(file_path)
        
        # Convert the image to RGBA mode to support transparency
        image = image.convert("RGBA")
        
        # Create a transparent image with the same size
        transparent_image = Image.new("RGBA", image.size, (0, 0, 0, 0))
        
        # Save the transparent image, overwriting the original file
        transparent_image.save(file_path)
        
        print("Image converted to transparent successfully!")
    else:
        print("No file selected.")

# Create the main window
window = Tk()
window.title("Transparent Image Converter")

# Create a button to open the image
open_button = Button(window, text="Open Image", command=open_image)
open_button.pack()

# Start the Tkinter event loop
window.mainloop()
